<?php

/** @var \Laravel\Lumen\Routing\Router $router */

/*
|--------------------------------------------------------------------------
| Application Routes
|----------------------s----------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});

//Route::post('/app/{appname}', 'ApplicationController@save')->name('appname');
$router->get('/app/{appname}','ApplicationController@get');
$router->get('/app','ApplicationController@getAll');
$router->get('/app/data/{appname}','ApplicationController@getData');
$router->post('/app/{appname}', 'ApplicationController@save');
$router->put('/app/{appname}','ApplicationController@update');
$router->get('/app/update/{appname}','ApplicationController@update');
$router->delete('/app/{appname}','ApplicationController@remove');
