<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Events\EnviarMensaje;


class ChatForm extends Component
{

    public $nombre;
    public $mensaje;

    protected $rules = [
        "nombre" => "required|min:6",
        "mensaje" => "required"
    ];

    protected $messages = [
        'nombre.required' => 'El campo nombre no puede estar vacio.',
        'nombre.min' => 'El campo nombre no puede tener menos de 6 caracteres.',
        'mensaje.required' => 'El campo mensaje no puede estar vacio.',
    ];


    

    public function mount()
    {
        $this->nombre= "";
        $this->mensaje= "";
    }

    public function render()
    {
        return view('livewire.chat-form');
    }

    public function enviarMensaje(){

        $this->validate();


        $datos = [
            "nombre" => $this->nombre,
            "mensaje" => $this->mensaje
        ];

      //  $this->emit("mensajeRecibido", $datos);

        event(new EnviarMensaje($this->nombre,$this->mensaje));
        
    }
}
